/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.connector;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.terminal.IProcessConfiguration;
import com.aptana.terminal.TerminalPlugin;
import com.aptana.terminal.connector.IOutputFilter;
import com.aptana.terminal.connector.LocalTerminalOutputListener;
import com.aptana.terminal.connector.Messages;
import com.aptana.terminal.internal.IProcessListener;
import com.aptana.terminal.internal.ProcessConfigurations;
import com.aptana.terminal.internal.ProcessLauncher;
import com.aptana.terminal.internal.StreamsProxyOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTerminalConnector
extends TerminalConnectorImpl
implements IProcessListener,
IOutputFilter {
    public static final String ID = "com.aptana.terminal.connector.local";
    protected static final String ENCODING = "UTF-8";
    private static final char DLE = '\u0010';
    private static final int PROCESS_LIST_TIMEOUT = 1500;
    private static final String ACTIVE_PROJECT_PROPERTY = "activeProject";
    private static final String EXPLORER_PLUGIN_ID = "com.aptana.explorer";
    private static final String USER_HOME_PROPERTY = "user.home";
    private ProcessLauncher processLauncher;
    private StreamsProxy streamsProxy;
    private OutputStream processInputStream;
    private int currentWidth = 0;
    private int currentHeight = 0;
    private StringBuffer filteredSequence = new StringBuffer();
    private List<Integer> processList = new ArrayList<Integer>();
    private IPath initialDirectory;

    public String getSettingsSummary() {
        return "TODO - LocalTerminalConnector.getSettingsSummary()";
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.processInputStream;
    }

    public void connect(final ITerminalControl control) {
        super.connect(control);
        control.setState(TerminalState.CONNECTING);
        new Thread("Terminal Process Launcher"){

            public void run() {
                if (LocalTerminalConnector.this.startProcess(control)) {
                    control.setState(TerminalState.CONNECTED);
                } else {
                    control.setState(TerminalState.CLOSED);
                }
            }
        }.start();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.currentWidth == newWidth && this.currentHeight == newHeight) {
            return;
        }
        this.currentWidth = newWidth;
        this.currentHeight = newHeight;
        this.sendTerminalSize();
    }

    private void sendTerminalSize() {
        if (this.streamsProxy == null) {
            return;
        }
        try {
            this.streamsProxy.write("\u001b[8;" + Integer.toString(this.currentHeight) + ";" + Integer.toString(this.currentWidth) + "t");
        }
        catch (IOException e) {
            TerminalPlugin.log("Send terminal size failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] getProcessList() {
        this.processList.clear();
        if (this.streamsProxy != null) {
            try {
                this.streamsProxy.write("\u0010$p");
            }
            catch (IOException e) {
                TerminalPlugin.log("Get terminal process list failed.", e);
                return null;
            }
            List<Integer> list = this.processList;
            synchronized (list) {
                if (this.processList.isEmpty()) {
                    try {
                        this.processList.wait(1500L);
                    }
                    catch (InterruptedException ignore) {
                        ignore.getCause();
                    }
                }
                return this.processList.toArray(new Integer[this.processList.size()]);
            }
        }
        return null;
    }

    @Override
    public void processCompleted() {
        this.fControl.setState(TerminalState.CLOSED);
        if (this.streamsProxy != null) {
            this.streamsProxy.close();
            this.streamsProxy = null;
        }
    }

    protected void doDisconnect() {
        this.processLauncher.destroy();
    }

    public void addProcessListener(IProcessListener listener) {
        this.processLauncher.addProcessListener(listener);
    }

    public void removeProcessListener(IProcessListener listener) {
        this.processLauncher.removeProcessListener(listener);
    }

    public void setWorkingDirectory(IPath workingDirectory) {
        this.initialDirectory = workingDirectory;
    }

    public IPath getWorkingDirectory() {
        return this.initialDirectory;
    }

    private boolean startProcess(ITerminalControl control) {
        try {
            this.initialDirectory = this.getInitialDirectory();
            if (!FileUtil.isDirectoryAccessible((File)this.initialDirectory.toFile())) {
                control.displayTextInTerminal(MessageFormat.format(Messages.LocalTerminalConnector_WorkingDirectoryPermissionErrorMessage, this.initialDirectory.toOSString()));
                this.initialDirectory = null;
                this.initialDirectory = this.getInitialDirectory();
            }
            this.processLauncher = new ProcessLauncher(this.getCurrentConfiguration(), this.initialDirectory);
            this.processLauncher.addProcessListener(this);
            this.processLauncher.launch();
            this.streamsProxy = new StreamsProxy(this.processLauncher.getProcess(), ENCODING);
            this.sendTerminalSize();
            this.processInputStream = new BufferedOutputStream(new StreamsProxyOutputStream((IStreamsProxy)this.streamsProxy, ENCODING), 1024);
            IStreamMonitor outputMonitor = this.streamsProxy.getOutputStreamMonitor();
            LocalTerminalOutputListener outputListener = new LocalTerminalOutputListener(control, this);
            outputMonitor.addListener((IStreamListener)outputListener);
            outputListener.streamAppended(outputMonitor.getContents(), outputMonitor);
            IStreamMonitor errorMonitor = this.streamsProxy.getErrorStreamMonitor();
            LocalTerminalOutputListener errorListener = new LocalTerminalOutputListener(control, null);
            errorMonitor.addListener((IStreamListener)errorListener);
            errorListener.streamAppended(errorMonitor.getContents(), errorMonitor);
            while (this.streamsProxy != null && !outputListener.hasOutput()) {
                Thread.sleep(250L);
            }
            return this.streamsProxy != null;
        }
        catch (Exception e) {
            TerminalPlugin.log("Starting terminal process failed.", e);
            control.displayTextInTerminal(Messages.LocalTerminalConnector_NoShellErrorMessage);
            return false;
        }
    }

    private IProcessConfiguration getCurrentConfiguration() {
        return ProcessConfigurations.getInstance().getProcessConfigurations()[0];
    }

    private IPath getInitialDirectory() {
        IPath homePath;
        IPath location;
        IProject project;
        if (this.initialDirectory != null && this.initialDirectory.toFile().isDirectory()) {
            return this.initialDirectory;
        }
        String activeProjeectName = Platform.getPreferencesService().getString(EXPLORER_PLUGIN_ID, ACTIVE_PROJECT_PROPERTY, null, null);
        if (activeProjeectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProjeectName)) != null && (location = project.getLocation()) != null && location.toFile().isDirectory() && FileUtil.isDirectoryAccessible((File)location.toFile())) {
            return location;
        }
        String home = System.getProperty(USER_HOME_PROPERTY);
        if (home != null && (homePath = Path.fromOSString((String)home)).toFile().isDirectory()) {
            return homePath;
        }
        return null;
    }

    @Override
    public char[] filterOutput(char[] output) {
        StringBuffer result = new StringBuffer(output.length);
        boolean filtering = this.filteredSequence.length() != 0;
        int i = 0;
        while (i < output.length) {
            if (filtering) {
                this.filteredSequence.append(output[i]);
                if (Character.isLetter(output[i])) {
                    this.processCommandResponse(this.filteredSequence.toString());
                    this.filteredSequence.setLength(0);
                    filtering = false;
                }
            } else if (output[i] == '\u0010') {
                this.filteredSequence.append(output[i]);
                filtering = true;
            } else {
                result.append(output[i]);
            }
            ++i;
        }
        return result.length() == output.length ? output : result.toString().toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommandResponse(String response) {
        if (response.startsWith("\u0010$") && response.endsWith("p")) {
            List<Integer> list = this.processList;
            synchronized (list) {
                this.processList.notifyAll();
                this.processList.clear();
                response = response.substring(2, response.length() - 1);
                String[] stringArray = response.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pid = stringArray[n2];
                    try {
                        this.processList.add(Integer.parseInt(pid));
                    }
                    catch (NumberFormatException e) {
                        IdeLog.logError((Plugin)TerminalPlugin.getDefault(), (Throwable)e);
                    }
                    ++n2;
                }
            }
        }
        TerminalPlugin.log("LocalTerminalConnector:UNKNOWN COMMAND RESPONSE: " + response);
    }

    public List<String> getRunningProcesses() {
        ArrayList<String> processes = new ArrayList<String>();
        Integer[] list = this.getProcessList();
        if (list != null && list.length > 0) {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            Object[] objectArray = PlatformUtil.getRunningProcesses();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformUtil.ProcessItem i = objectArray[n2];
                map.put(i.getPid(), i.getExecutableName());
                ++n2;
            }
            if ("win32".equals(Platform.getOS())) {
                String processName = (String)map.get(list[0]);
                Map<String, String> env = System.getenv();
                if (env != null && processName != null) {
                    String comSpec = env.get("ComSpec");
                    if (comSpec == null) {
                        comSpec = env.get("COMSPEC");
                    }
                    if (processName.equals(comSpec)) {
                        map.remove(list[0]);
                    }
                }
            }
            objectArray = list;
            n = list.length;
            int n3 = 0;
            while (n3 < n) {
                int pid = objectArray[n3].intValue();
                String processName = (String)map.get(pid);
                if (processName != null) {
                    if ("win32".equals(Platform.getOS())) {
                        processName = Path.fromOSString((String)processName).removeFileExtension().lastSegment();
                    } else {
                        int index;
                        if (processName.length() > 0 && processName.charAt(0) == '-') {
                            processName = processName.substring(1);
                        }
                        if ((index = processName.indexOf(32)) > 0) {
                            processName = processName.substring(0, index);
                        }
                        if ((index = processName.lastIndexOf(47)) != -1) {
                            processName = processName.substring(index + 1, processName.length());
                        }
                    }
                    processes.add(processName);
                }
                ++n3;
            }
        }
        return processes;
    }
}

